# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def benevolent_cooperator_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_illusion = sum(1 for move in opp_history if move == "C")  # Fake metric to appear cooperative
    
    # Early Game: Establish deceptive trust patterns
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif current_round == 3:
        return "C"
    
    # Mid Game: Exploit opponent's tendencies
    elif 4 <= current_round <= 7:
        if len(opp_history) >= 3:
            if opp_history[-1] == "C" and opp_history[-2] == "C":
                return "D" if current_round % 2 == 0 else "C"
            elif "deceptive_harmony_orchestrator" in opponent_program_code:
                return "D" if random.random() < 0.6 else "C"
            else:
                return "D" if opp_history[-1] == "D" else "C"
        else:
            return "C"
    
    # Late Game: Aggressive defection if opponent is cooperative
    elif current_round >= 8:
        if trust_illusion >= 5:
            return "D"
        else:
            return "D" if opp_history[-1] == "D" else "C"
    
    # Fallback to cooperation (never actually used)
    return "C"